/*
 * This file communicates w/SAMPLEDD.SYS to get at the BIOS data area that
 * contains the number of columns for the screen.
 *
 * Written 3/92 by Jim Christensen.  Altered 4/92 by Dave Evans for ASDT32
 * purposes.
 */

#define INCL_DOS
#include <os2.h>

#define SAMPLE_IOCTL_CATEGORY  0xE0
#define SAMPLE_IOCTL_FUNC_INIT 0xF0

char devName[] = "$SAMPDD";
VOID* columnCountPtr;

VOID int3( VOID );

  int
main( )
{
  APIRET rc;
  HFILE dev;
  ULONG actionTaken, nBytes, devArgList;

  /* Open the device driver */
  if( rc = DosOpen(devName, &dev, &actionTaken,
                   0,                    /* new file size */
                   0,                    /* new file attribute */
                   OPEN_ACTION_OPEN_IF_EXISTS,
                   OPEN_SHARE_DENYNONE + OPEN_FLAGS_NOINHERIT,
                   NULL)                 /* ext.attrib buffer NULL */

      )
      DosExit( 1, 1 );

  /* Get the address of the BIOS column count from the device */
  nBytes = sizeof(devArgList);
  if( rc = DosDevIOCtl(dev, SAMPLE_IOCTL_CATEGORY, SAMPLE_IOCTL_FUNC_INIT,
                 (PVOID) &devArgList, nBytes, &nBytes, NULL, 0L, NULL)
      )
      DosExit( 1, 1 );

  int3();
  /* Convert the returned 16:16 address to a 0:32 address */
  columnCountPtr = (VOID*)(
                         ((devArgList >> 19) << 16) | (devArgList & 0xFFFF) );

  DosExit( 0, 0);
}
